﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Runtime.InteropServices.WindowsRuntime;
using System.Text;
using System.Threading.Tasks;
using CE3IO;

namespace pl3w
{
    public class Plist
    {
        ReadCE3 rd;
        public List<Bsch3VPlInfo> plInfoList;


        public Plist()
        {
            rd = new ReadCE3();
            plInfoList = new List<Bsch3VPlInfo>();
        }



        private void Clear()
        {
            plInfoList.Clear();
        }


        public bool Proc(string[] fileNames)
        {
            bool retv = true;
            int i;

            Clear();

            int files = fileNames.Length;
            for (i = 0; i < files; i++)
            {
                if (!ReadSrc(fileNames[i]))
                {
                    Clear();
                    return false;
                }
            }
            
            //int compCount = plInfoList.Count;
            plInfoList.Sort(CompPInfo);
            SetStatux();
            return retv;
        }


        private void SetStatux()
        {
            int len = plInfoList.Count;
            for(int index = 1; index < len; index++)
            {
                int prev = index - 1;
                if( plInfoList[index].prefix== plInfoList[prev].prefix &&
                    plInfoList[index].suffix == plInfoList[prev].suffix)
                {
                    if (plInfoList[index].pname == plInfoList[prev].pname)
                    {
                        plInfoList[index].status = "*";
                    }
                    else
                    {
                        plInfoList[index].status = "?";
                    }
                }
            }
        }


        private static int CompPInfo(Bsch3VPlInfo plInfo1, Bsch3VPlInfo plInfo2)
        {
            int c = String.Compare(plInfo1.prefix, plInfo2.prefix);
            if (c != 0) return c;

            int suffix1;
            int suffix2;

            if (!int.TryParse(plInfo1.suffix, out suffix1)) suffix1 = 0;
            if (!int.TryParse(plInfo2.suffix, out suffix2)) suffix2 = 0;
            return suffix1 - suffix2;
        }


        private bool ReadComponent()
        {
            string s1;
            string s2;

            Bsch3VPlInfo plInfo = new Bsch3VPlInfo();

            while (rd.GetRecord(out s1, out s2))
            {
                if (s1 == "-COMPONENT")
                {
                    //部品番号が設定されているものは登録する
                    if(plInfo.prefix!="" || plInfo.suffix!="") plInfoList.Add(plInfo);
                    return true;
                }
                else if(s1 == "+BSCH3_LIB_V.1.0")
                {
                    if (!ReadCompLib(plInfo)) return false; ;
                }
                else if (s1 == "R")
                {
                    string refnum = ReadCE3.DecodeCE3String(s2);
                    int len = refnum.Length;
                    int prefixEndIndex = len - 1;
                    while (prefixEndIndex >= 0)
                    {
                        if (!Char.IsDigit(refnum[prefixEndIndex])){
                            break;
                        }
                        prefixEndIndex--;
                    }
                    int prefixfLen = prefixEndIndex + 1;
                    if (prefixfLen <= 0)
                    {
                        plInfo.prefix = "";
                    }
                    else
                    {
                        plInfo.prefix = refnum.Substring(0, prefixfLen);
                    }

                    int suffixLen = len - prefixfLen;
                    if (suffixLen <= 0)
                    {
                        plInfo.suffix = "";
                    }
                    else
                    {
                        plInfo.suffix = refnum.Substring(prefixfLen);
                    }
                }
                else if (s1 == "N")
                {
                    plInfo.pname = ReadCE3.DecodeCE3String(s2);
                }
                else if(s1 == "MFR")
                {
                   plInfo.mnf = ReadCE3.DecodeCE3String(s2);
                }
                else if (s1 == "MFRPN")
                {
                    plInfo.mnf_pn = ReadCE3.DecodeCE3String(s2);
                }
                else if (s1 == "PKG")
                {
                    plInfo.pkg = ReadCE3.DecodeCE3String(s2);
                }
                else if (s1 == "NOTE")
                {
                    plInfo.note = ReadCE3.DecodeCE3String(s2);
                }
                else if (s1[0] == '+')
                {
                    s1 = "-" + s1.Substring(1);
                    if (!rd.SkipTo(s1)) return false;
                }

            }



            return false;
        }

        //部品情報の中のライブラリ情報
        private bool ReadCompLib(Bsch3VPlInfo plInfo)
        {
            string s1;
            string s2;

            
            while (rd.GetRecord(out s1, out s2))
            {
                if (s1 == "-BSCH3_LIB_V.1.0")
                {
                    return true;
                }
                else if (s1 == "+COMP")
                {
                    if (!ReadCOMP(plInfo)) return false;
                }
                else if (s1[0] == '+')
                {
                    s1 = "-" + s1.Substring(1);
                    if (!rd.SkipTo(s1)) return false;
                }
            }
            return false;
        }

        //部品情報の中のライブラリ情報
        private bool ReadCOMP(Bsch3VPlInfo plInfo)
        {
            string s1;
            string s2;


            while (rd.GetRecord(out s1, out s2))
            {
                if (s1 == "-COMP")
                {
                    return true;
                }
                else if (s1 == "NOTE")
                {
                    plInfo.comp_info = ReadCE3.DecodeCE3String(s2);
                }
                else if (s1[0] == '+')
                {
                    s1 = "-" + s1.Substring(1);
                    if (!rd.SkipTo(s1)) return false;
                }
            }
            return false;
        }








        private bool ReadSrc(string path)
        {

            bool retv = true;
            StreamReader sr;
            try
            {
                sr= new StreamReader(path);
            }
            catch
            {
                return false;
            }
            rd.Attach(sr);

            bool firstRec = true;
            string s1;
            string s2;

            while (rd.GetRecord(out s1, out s2))
            {
                if (firstRec)
                {
                    if (s1 != "+BSCH3_DATA_V.1.0")
                    {
                        retv = false;
                        break;
                    }
                    firstRec = false;
                    continue;
                }
                if(s1 == "+COMPONENT")
                {
                    if (!ReadComponent()) break;
                }
                else if(s1 == "-BSCH3_DATA_V.1.0")
                {
                    firstRec = true;
                }
                else if(s1[0] == '+')
                {
                    s1 = "-" + s1.Substring(1);
                    if (!rd.SkipTo(s1)) break;
                }
            }
            sr.Close();
            sr.Dispose();
            return retv;
        }
    }

    public class Bsch3VPlInfo
    {
        public string status;
        public string prefix;
        public string suffix;
        public string pname;
        public string mnf;
        public string mnf_pn;
        public string pkg;
        public string note;
        public string comp_info;

        public Bsch3VPlInfo()
        {
            status = "";
            prefix = "";
            suffix = "";
            pname = "";
            mnf = "";
            mnf_pn = "";
            pkg = "";
            note = "";
            comp_info = "";
        }
    }

}
