﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms.VisualStyles;

namespace pl3w
{
    public class SetupVal
    {
        public SetupVal()
        {
            startLine = 1;
            colStatus = "A"; 
            colPrefix = "B";
            colSuffix = "C";
            colPN     = "D";
            colMnf    = "E";
            colMnfPN  = "F";
            colPkg    = "G";
            colNote   = "H";
            colCompInfo = "I";
            enMnf    = true;
            enMnfPN = true;
            enPkg   = true;
            enNote  = true;
            enCompInfo = true;


            err_startLine = true;
            err_colStatus = true;
            err_colPrefix = true;
            err_colSuffix = true;
            err_colPN = true;
            err_colMnf = true;
            err_colMnfPN = true;
            err_colPkg = true;
            err_colNote = true;
            err_colCompInfo = true;

        }


        //コピーコンストラクタ
        public SetupVal(SetupVal sv) :this()
        {
            startLine = sv.startLine;
            colStatus = sv.colStatus;
            colPrefix = sv.colPrefix;
            colSuffix = sv.colSuffix;
            colPN = sv.colPN;
            colMnf = sv.colMnf;
            colMnfPN = sv.colMnfPN;
            colPkg = sv.colPkg;
            colNote = sv.colNote;
            colCompInfo = sv.colCompInfo;
            enMnf = sv.enMnf;
            enMnfPN = sv.enMnfPN;
            enPkg = sv.enPkg;
            enNote = sv.enNote;
            enCompInfo = sv.enCompInfo;
        }






        public int startLine;
        public string colStatus;
        public string colPrefix;
        public string colSuffix;
        public string colPN;
        public string colMnf;
        public string colMnfPN;
        public string colPkg;
        public string colNote;
        public string colCompInfo;
        public bool enMnf;
        public bool enMnfPN;
        public bool enPkg;
        public bool enNote;
        public bool enCompInfo;


        public bool err_startLine;
        public bool err_colStatus;
        public bool err_colPrefix;
        public bool err_colSuffix;
        public bool err_colPN;
        public bool err_colMnf;
        public bool err_colMnfPN;
        public bool err_colPkg;
        public bool err_colNote;
        public bool err_colCompInfo;


        public void Load()
        {
            startLine = Properties.Settings.Default.startLine;
            colStatus = Properties.Settings.Default.columnStatus;
            colPrefix = Properties.Settings.Default.columnRefPrefix;
            colSuffix = Properties.Settings.Default.columnRefSuffix;
            colPN = Properties.Settings.Default.columnPartName;
            colMnf = Properties.Settings.Default.columnMnf;
            colMnfPN = Properties.Settings.Default.columnMnfPN;
            colPkg = Properties.Settings.Default.columnPkg;
            colNote = Properties.Settings.Default.columnNote;
            colCompInfo = Properties.Settings.Default.columnCompInfo;
            enMnf = Properties.Settings.Default.enMnf;
            enMnfPN = Properties.Settings.Default.enMnfPN;
            enPkg = Properties.Settings.Default.enPkg;
            enNote = Properties.Settings.Default.enNote;
            enCompInfo = Properties.Settings.Default.enCompInfo;
        }

        public void Save()
        {
            Properties.Settings.Default.startLine = startLine;
            Properties.Settings.Default.columnStatus = colStatus;
            Properties.Settings.Default.columnRefPrefix = colPrefix;
            Properties.Settings.Default.columnRefSuffix = colSuffix;
            Properties.Settings.Default.columnPartName = colPN;
            Properties.Settings.Default.columnMnf = colMnf;
            Properties.Settings.Default.columnMnfPN = colMnfPN;
            Properties.Settings.Default.columnPkg = colPkg;
            Properties.Settings.Default.columnNote = colNote;
            Properties.Settings.Default.columnCompInfo = colCompInfo;
            Properties.Settings.Default.enMnf = enMnf;
            Properties.Settings.Default.enMnfPN = enMnfPN;
            Properties.Settings.Default.enPkg = enPkg;
            Properties.Settings.Default.enNote = enNote;
            Properties.Settings.Default.enCompInfo = enCompInfo;

            Properties.Settings.Default.Save();
        }




        //エラーがないときtrueを返す
        public bool CheckValue()
        {
            int[] cols = new int[10];   //カラムの重複チェック用
            int colIndex = 0;
            bool err = false;
            int n,i;

            err_startLine = (startLine < 1 || startLine > 100);
            err |= err_startLine;

            cols[colIndex++] = n = Utils.ColumnToIndex(colStatus);
            err |= (err_colStatus = (n < 1 || n > 26));


            n = Utils.ColumnToIndex(colPrefix);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colPrefix = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colSuffix);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colSuffix = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colPN);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colPN = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colMnf);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colMnf = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colMnfPN);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colMnfPN = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colPkg);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colPkg = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colNote);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colNote = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            n = Utils.ColumnToIndex(colCompInfo);
            for (i = 0; i < colIndex; i++)
            {
                if (cols[i] == n) break;
            }
            err |= (err_colCompInfo = (i < colIndex || n < 1 || n > 26));
            cols[colIndex++] = n;

            return !err;
        }

    }
}
