﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace pl3w
{
    public partial class FormSetup : Form
    {
        //public SetupInfo setupVal;

        private SetupVal setupVal;


        public SetupVal SetupVal { 
            get => setupVal; 
            set => setupVal = new SetupVal(value); 
        }

        public FormSetup()
        {
            InitializeComponent();
        }

        private void FormSetup_Load(object sender, EventArgs e)
        {
            setupVal.CheckValue();
            SetItems();
            SetCheckStatus();
        }


        private void SetItems()
        {
            textBoxStartLine.Text = setupVal.startLine.ToString();
            textBoxColumnStatus.Text = setupVal.colStatus;
            textBoxColumnName.Text = setupVal.colPN;
            textBoxColumnRefPrefix.Text = setupVal.colPrefix;
            textBoxColumnRefSuffix.Text = setupVal.colSuffix;
            textBoxColumnMnf.Text = setupVal.colMnf;
            textBoxColumnMnfPN.Text = setupVal.colMnfPN;
            textBoxColumnPkg.Text = setupVal.colPkg;
            textBoxColumnNote.Text = setupVal.colNote;
            textBoxColumnCompInfo.Text = setupVal.colCompInfo;
            checkBoxMnf.Checked = setupVal.enMnf;
            checkBoxMnfPN.Checked = setupVal.enMnfPN;
            checkBoxPackage.Checked = setupVal.enPkg;
            checkBoxNote.Checked = setupVal.enNote;
            checkBoxCompInfo.Checked = setupVal.enCompInfo;
        }

        private void ReadItems()
        {
            int n;
            if(!int.TryParse(textBoxStartLine.Text, out n))
            {
                n = 0;
            }
            setupVal.startLine = n;

            setupVal.colStatus = textBoxColumnStatus.Text;
            setupVal.colPN = textBoxColumnName.Text;
            setupVal.colPrefix = textBoxColumnRefPrefix.Text;
            setupVal.colSuffix = textBoxColumnRefSuffix.Text;
            setupVal.colMnf = textBoxColumnMnf.Text;
            setupVal.colMnfPN = textBoxColumnMnfPN.Text;
            setupVal.colPkg = textBoxColumnPkg.Text;
            setupVal.colNote = textBoxColumnNote.Text;
            setupVal.colCompInfo = textBoxColumnCompInfo.Text;
            setupVal.enMnf = checkBoxMnf.Checked;
            setupVal.enMnfPN = checkBoxMnfPN.Checked;
            setupVal.enPkg = checkBoxPackage.Checked;
            setupVal.enNote = checkBoxNote.Checked;
            setupVal.enCompInfo = checkBoxCompInfo.Checked;
        }


        private void SetCheckStatus()
        {
           
            textBoxStartLine.BackColor = (setupVal.err_startLine ? Color.Orange : SystemColors.Window);
            textBoxColumnStatus.BackColor = (setupVal.err_colStatus ? Color.Orange : SystemColors.Window);
            textBoxColumnRefPrefix .BackColor = (setupVal.err_colPrefix ? Color.Orange : SystemColors.Window);
            textBoxColumnRefSuffix.BackColor = (setupVal.err_colSuffix ? Color.Orange : SystemColors.Window);
            textBoxColumnName.BackColor = (setupVal.err_colPN ? Color.Orange : SystemColors.Window);
            textBoxColumnMnf.BackColor = (setupVal.err_colMnf ? Color.Orange : SystemColors.Window);
            textBoxColumnMnfPN.BackColor = (setupVal.err_colMnfPN ? Color.Orange : SystemColors.Window);
            textBoxColumnPkg.BackColor = (setupVal.err_colPkg ? Color.Orange : SystemColors.Window);
            textBoxColumnNote.BackColor = (setupVal.err_colNote ? Color.Orange : SystemColors.Window);
            textBoxColumnCompInfo.BackColor = (setupVal.err_colCompInfo ? Color.Orange : SystemColors.Window);

           
        }

        private void IDOK_Click(object sender, EventArgs e)
        {
            ReadItems();
            if (!setupVal.CheckValue())
            {
                SetCheckStatus();
                return;
            }

            DialogResult = DialogResult.OK;
        }
    }
}
