﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;


using ClosedXML.Excel;


namespace pl3w
{
    public partial class FormMain : Form
    {
        private SetupVal setupVal;


        public FormMain()
        {
            InitializeComponent();
            setupVal = new SetupVal();
            setupVal.Load();
        }

        private void buttonExec_Click(object sender, EventArgs e)
        {
            int len = listBoxSrcFiles.Items.Count;
            string[] fileNames = new string[len];
            for(int i = 0; i < len; i++) {
                string s = listBoxSrcFiles.Items[i].ToString();
                fileNames[i] = s; 
            }
            string dstFileName = textBoxDstFile.Text;


            Plist pl = new Plist();

            if (pl.Proc(fileNames))
            {
                if(SaveFile(dstFileName, pl.plInfoList))
                {
                    MessageBox.Show("Finished", "PL3W");
                    return;
                }
            }

            MessageBox.Show("File I/O error", "PL3W");

        }

        private bool SaveFile(string fileName, List<Bsch3VPlInfo> plInfoList)
        {

            try
            {
                System.IO.File.Delete(fileName);
            }
            catch
            {
                return false;
            }


            try
            {
                using (var workbook = new XLWorkbook())
                {
                    var ws = workbook.Worksheets.Add("Sheet1");

                    int row = setupVal.startLine;
                    int index;
                    int len = plInfoList.Count;


                    for (index = 0; index < len; index++, row++)
                    {
                        int col;

                        col = Utils.ColumnToIndex(setupVal.colStatus);
                        ws.Cell(row, col).DataType = XLDataType.Text;
                        ws.Cell(row, col).SetValue(plInfoList[index].status);

                        col = Utils.ColumnToIndex(setupVal.colPrefix);
                        ws.Cell(row, col).DataType = XLDataType.Text;
                        ws.Cell(row, col).SetValue(plInfoList[index].prefix);

                        col = Utils.ColumnToIndex(setupVal.colSuffix);
                        ws.Cell(row, col).DataType = XLDataType.Number;
                        ws.Cell(row, col).Value=(plInfoList[index].suffix);

                        col = Utils.ColumnToIndex(setupVal.colPN);
                        ws.Cell(row, col).DataType = XLDataType.Text;
                        //ws.Cell(row, col).Value = plInfoList[index].pname;
                        ws.Cell(row, col).SetValue(plInfoList[index].pname);

                        if (setupVal.enMnf)
                        {
                            col = Utils.ColumnToIndex(setupVal.colMnf);
                            ws.Cell(row, col).DataType = XLDataType.Text;
                            ws.Cell(row, col).SetValue(plInfoList[index].mnf);
                        }

                        if (setupVal.enMnfPN)
                        {
                            col = Utils.ColumnToIndex(setupVal.colMnfPN);
                            ws.Cell(row, col).DataType = XLDataType.Text;
                            ws.Cell(row, col).SetValue(plInfoList[index].mnf_pn);
                        }

                        if (setupVal.enPkg)
                        {
                            col = Utils.ColumnToIndex(setupVal.colPkg);
                            ws.Cell(row, col).DataType = XLDataType.Text;
                            ws.Cell(row, col).SetValue(plInfoList[index].pkg);
                        }

                        if (setupVal.enNote)
                        {
                            col = Utils.ColumnToIndex(setupVal.colNote);
                            ws.Cell(row, col).DataType = XLDataType.Text;
                            ws.Cell(row, col).SetValue(plInfoList[index].note);
                        }


                        if (setupVal.enCompInfo)
                        {
                            col = Utils.ColumnToIndex(setupVal.colCompInfo);
                            ws.Cell(row, col).DataType = XLDataType.Text;
                            ws.Cell(row, col).SetValue(plInfoList[index].comp_info);
                        }

                    }

                    ws.Columns(1, 26).AdjustToContents();
                    ws.Columns(1, 26).Style.Alignment.Horizontal = XLAlignmentHorizontalValues.Left;
                    ws.Column(Utils.ColumnToIndex(setupVal.colPrefix)).Style.Alignment.Horizontal = XLAlignmentHorizontalValues.Right;
                    workbook.SaveAs(fileName);

                }
            }
            catch
            {
                return false;
            }
            return true;
        }

        private void buttonExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void buttonRefSrc_Click(object sender, EventArgs e)
        {
            if(openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                String[] fileNames = openFileDialog1.FileNames;
                addSrcFiles(fileNames);
            }


        }

        private void buttonClear_Click(object sender, EventArgs e)
        {
            listBoxSrcFiles.Items.Clear();
            textBoxDstFile.Text = "";
            buttonExec.Enabled = false;

        }

        private void buttonSetup_Click(object sender, EventArgs e)
        {
            FormSetup dlg = new FormSetup();
            dlg.SetupVal = setupVal;
            if(dlg.ShowDialog() == DialogResult.OK)
            {
                setupVal = dlg.SetupVal;
                setupVal.Save();
            }
            dlg.Dispose();

        }

        private void buttonRefDst_Click(object sender, EventArgs e)
        {
            saveFileDialog1.FileName = textBoxDstFile.Text;
            if (saveFileDialog1.ShowDialog()== DialogResult.OK)
            {
                textBoxDstFile.Text = saveFileDialog1.FileName;    
            }
        }

        private int addSrcFiles(string[]fileNames)
        {
            int count = 0;

            int names = fileNames.Length;

            for(int j = 0; j < names; j++)
            {

                if (Path.GetExtension(fileNames[j]).ToLower() == ".ce3")
                {
                    int len = listBoxSrcFiles.Items.Count;
                    bool exist = false;
                    for(int i = 0; i < len; i++)
                    {
                        if (listBoxSrcFiles.Items[i].ToString() == fileNames[j]){
                            exist = true;
                        }
                    }
                    if (!exist)
                    {
                        if(textBoxDstFile.Text.Length == 0)
                        {
                            textBoxDstFile.Text = Path.ChangeExtension(fileNames[j], "xlsx");
                        }
                        buttonExec.Enabled = true;
                       

                        listBoxSrcFiles.Items.Add(fileNames[j]);
                        count++;
                    }
                }

            }

            return count;
        }


        //ドラッグアンドドロップによる処理
        private void listBoxSrcFiles_DragDrop(object sender, DragEventArgs e)
        {
            System.Diagnostics.Debug.WriteLine("Drag and drop");
            string[] fileNames = (string[])e.Data.GetData(DataFormats.FileDrop, false);

            addSrcFiles(fileNames);

        }

        private void listBoxSrcFiles_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.All;
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }

        }

        private void buttonAbout_Click(object sender, EventArgs e)
        {
            AboutBox dlg = new AboutBox();
            dlg.ShowDialog();
            dlg.Dispose();
        }
    }


    public class Utils
    {
        //AAなどのカラム指定を1始まりのインデックスに変換する。
        public static int ColumnToIndex(string strColumn)
        {
            string strc = strColumn.ToLower();
            int retv = 0;
            int len = strc.Length;
            if (len == 0 || len > 2) return -1;
            for (int i = 0; i < len; i++)
            {
                retv = retv * 26 + (int)strc[i] - (int)'a' + 1;
            }
            return retv;
        }


    }



}
