﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Printing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static System.Net.Mime.MediaTypeNames;

namespace EMFPRINT
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            EnableUPDown();
            pagePrint = 0;
            pages = 0;
            pageMargins = new Margins(MARGIN, MARGIN, MARGIN, MARGIN);
        }

        private const int MARGIN = 100 * 100 / 254; //10mm


        private int pagePrint;
        private int pages;
        Margins pageMargins;


        private void SelectEMF_Click(object sender, EventArgs e)
        {
            if(openFileDialog1.ShowDialog(this)== DialogResult.OK)
            {
                string[] files = openFileDialog1.FileNames;
                readFiles(files);
                //listBoxFiles.Items.AddRange(files);

            }
        }

        private void Print_Click(object sender, EventArgs e)
        {
            //printDialogのプロパティでUseEXDialogをfalseにしないと、プレビュー付きのダイアログになる
            pages = listBoxFiles.Items.Count;
            if (pages <= 0) return;
            printDocument1.DefaultPageSettings.Margins = pageMargins;
            printDialog1.PrinterSettings = new System.Drawing.Printing.PrinterSettings();
            printDialog1.Document = printDocument1;
            if (printDialog1.ShowDialog()== DialogResult.OK)
            {
                pagePrint = 0;
                printDocument1.Print();
            }
        }


        private void ClearFiles_Click(object sender, EventArgs e)
        {
            listBoxFiles.Items.Clear();
            EnableUPDown();
        }

        private void ItemUpDown(bool up)
        {
            int selectedIndex = listBoxFiles.SelectedIndex;
            int items = listBoxFiles.Items.Count;
            int indexNext = selectedIndex + (up? -1 : 1);

            string s = listBoxFiles.Items[selectedIndex].ToString();
            listBoxFiles.Items.RemoveAt(selectedIndex);
            listBoxFiles.Items.Insert(indexNext, s);
            listBoxFiles.SelectedIndex = indexNext;
        }


        private void buttonUp_Click(object sender, EventArgs e)
        {
            ItemUpDown(true);
        }


        private void buttonDown_Click(object sender, EventArgs e)
        {
            ItemUpDown(false);

        }

        private void EnableUPDown()
        {
            int selectedIndex = listBoxFiles.SelectedIndex;
            int items = listBoxFiles.Items.Count;

            buttonUp.Enabled = (items > 0 && selectedIndex > 0 ? true : false);
            buttonDown.Enabled = (items > 0 && selectedIndex < (items - 1) ? true : false);
        }

        private void listBoxFiles_SelectedIndexChanged(object sender, EventArgs e)
        {
            EnableUPDown();
        }


        private bool drawEMFToPrinter(PrintPageEventArgs e, string filename)
        {
            try{
                Metafile metafile = new Metafile(filename);
                System.Diagnostics.Debug.WriteLine(metafile.Size);
                System.Diagnostics.Debug.WriteLine(e.MarginBounds);
                Size szMetafile = metafile.Size;
                Rectangle rcDraw = e.MarginBounds;
                int printW=rcDraw.Width;
                int printH=rcDraw.Height;
                int x = e.MarginBounds.X;
                int y = e.MarginBounds.Y;

                if ((float)(szMetafile.Width)/szMetafile.Height > (float)printW / printH)
                {   //メタファイルの方が横長のとき
                    printH = (int)((float)(szMetafile.Height) * printW / szMetafile.Width);
                    y+= (rcDraw.Height - printH) / 2;
                }
                else
                {
                    printW = (int)((float)(szMetafile.Width) * printH / szMetafile.Height);
                    x += (rcDraw.Width - printW) / 2;
                }
                rcDraw = new Rectangle(x,y,printW,printH);

                e.Graphics.DrawImage(metafile, rcDraw);
                metafile.Dispose();
            }
            catch { return false; }
            return true;
        }

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            string filename = listBoxFiles.Items[pagePrint].ToString();
            if (!drawEMFToPrinter(e, filename))
            {
                e.HasMorePages = false;
            }
            else {
                pagePrint++;
                e.HasMorePages = (pagePrint >= pages ? false : true);
            }
        }

        private void buttonAbout_Click(object sender, EventArgs e)
        {
            MessageBox.Show("EMFPRINT Version 20240511\nCopyright(c)2024 H.Okada (www.suigyodo.com)");
        }


        private void readFileList(string path)
        {
            try
            {
                using (StreamReader sr = new StreamReader(path, Encoding.UTF8))
                {
                    string emfpath;
                    while ((emfpath = sr.ReadLine()) != null)
                    {
                        if (!System.IO.File.Exists(emfpath))
                        {
                            continue;
                        }
                        string ext = Path.GetExtension(emfpath);
                        ext = ext.ToLower();
                        if (ext == ".emf")
                        {
                            listBoxFiles.Items.Add(emfpath);
                        }
                    }
                }
            }
            catch { }
        }

        private void readFiles(string[] pathArray)
        {
            int len = pathArray.Length;
            for (int i = 0; i < len; i++)
            {
                if (!System.IO.File.Exists(pathArray[i]))
                {
                    continue;
                }

                string ext = Path.GetExtension(pathArray[i]);
                ext = ext.ToLower();
                if (ext == ".emf")
                {
                    listBoxFiles.Items.Add(pathArray[i]);
                }
                else if (ext == ".txt" || ext == ".csv")
                {
                    readFileList(pathArray[i]);
                }
            }
        }


        private void Form1_Shown(object sender, EventArgs e)
        {
            string[] arguments = Environment.GetCommandLineArgs();
            string[] files;
            int len = arguments.Length;
            files= new string[len-1];
            Array.Copy(arguments,1,files,0,len-1);
            readFiles(files);
        }
    }
}
