import sys
import os
import CE3Data

class TAGValue:
    def __init__(self):
        self.text=''
        self.attribute=self.ATTRB_H
        self.layer=0
        self.x=0
        self.y=0
    
    def ToString(self):
        return "S:{str},D:{dir},L:{layer},X:{xpos},Y:{ypos}".format(str=self.text,dir=self.attribute,layer=self.layer,xpos=self.x,ypos=self.y)
    
    ATTRB_H=1
    ATTRB_V=0

class CE3TagList(CE3Data.CE3Data):
    def __init__(self):
        self.TagList=[]

    def ScanTag(self):
        index=0
        while True:
            index=self.GetSchematicObjBeginIndex(index)
            endindex=self.GetSchematicObjEndIndex(index)
            if index<0 or endindex<0:   #図面オブジェクトの範囲を正しく取得できなかったら終わる。
                break;
            if self.elementList[index].word=="+TAG":
                tagObj=TAGValue()

                varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="L")   #図面オブジェクトの中からL:xを取り出す
                if varIndex>0:
                    tagObj.layer=int(self.elementList[varIndex].val)

                varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="X")   #図面オブジェクトの中からX:xを取り出す
                if varIndex>0:
                    tagObj.x=int(self.elementList[varIndex].val)

                varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="Y")   #図面オブジェクトの中からY:xを取り出す
                if varIndex>0:
                    tagObj.y=int(self.elementList[varIndex].val)
                
                varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="D")   #図面オブジェクトの中からD:xを取り出す
                if varIndex>0:
                    tagObj.attribute=  TAGValue.ATTRB_H if int(self.elementList[varIndex].val)==1 else TAGValue.ATTRB_V

                varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="S")   #図面オブジェクトの中からS:xを取り出す
                if varIndex>0:
                    tagObj.text = self.elementList[varIndex].val

                self.TagList.append(tagObj)
            index=endindex+1

    def DumpTag(self):
        for tagdata in self.TagList:
            print(tagdata.ToString())
            
        




# if __name__ == '__main__':
#     # テスト用
#     argv = sys.argv     # コマンドライン引数を得る
#     argc = len(argv)    # コマンドライン引数の数
#     if argc<2 :
#         srcfilepath = 'test.ce3'
#         #sys.exit()
#     else:
#         srcfilepath = argv[1]
#     dstfilepath = os.path.splitext(srcfilepath)[0]+"_copy.ce3"
#     ce3data = CE3TagList()
#     ce3data.ReadFile(filepath=srcfilepath)
#     ce3data.ScanTag()
#     ce3data.DumpTag()
#     ce3data.WriteFile(filepath=dstfilepath)
