import sys
import os
import shutil
from functools import cmp_to_key
import CE3TagList


class TagConInfoVal:
    def __init__(self):
        self.page =0
        self.TagValue=None
    
    def ToString(self):
        return "{0:d}:{1:s}".format(self.page,self.TagValue.ToString())



def cmpTagMapVal(a,b):  #ソートのための比較関数
    if a.TagValue.text < b.TagValue.text:
        return -1
    elif a.TagValue.text > b.TagValue.text:
        return 1
    elif a.page < b.page:
        return -1
    elif a.page > b.page:
        return 1
    else:
        return 0

class CE3TagConInfo:
    def __init__(self):
        self.TagMapValList = []
        self.ce3fileList =[]
        self.InfoLayer=5             #マップデータを書き込むレイヤー


    #listfileは対象のCE3ファイルを1行1ファイルに書いたテキストファイル
    #infoLayer は結果を書き込むレイヤー
    #bCleanupMapLayer がTrueのとき、いったんmapLayerを空にする
    def Read_Files(self,pathList,infoLayer,bCleanupMapLayer):
        self.InfoLayer=infoLayer
        page=0;
        for path in pathList:


            ce3data = CE3TagList.CE3TagList()
            ce3data.ReadFile(path)
            if bCleanupMapLayer==True:
                ce3data.DeleteLayer(infoLayer)    
            ce3data.ScanTag()
            #print(path.strip());
            self.ce3fileList.append(ce3data)
            for tagval in ce3data.TagList:
                tagConInfoVal = TagConInfoVal()
                tagConInfoVal.page=page
                tagConInfoVal.TagValue=tagval
                self.TagMapValList.append(tagConInfoVal)
            page += 1
        self.TagMapValList = sorted(self.TagMapValList,key=cmp_to_key(cmpTagMapVal))


    def Update_PageNumber(self):
        pages = len(self.ce3fileList)
        i=0
        while i<pages:
            self.ce3fileList[i].SetPageNumber(page=i+1,pages=pages)
            i+=1
    


    def Save_files(self):
        for ce3data in self.ce3fileList:
            ce3data.WriteFile()
    



 #   def sortTagMapValList(self):
 #       self.TagMapValList = sorted(self.TagMapValList,key=cmp_to_key(cmpTagMapVal))


    def dumpTagMapValList(self):
        for tagConInfoVal in self.TagMapValList:
            print(tagConInfoVal.ToString())

    ## タグに添える 1:(400,510) 2:(220,380) のような文字列を作る
    # タグに添える 1:A2 2:D5 のような文字列を作る
    # インデックスは self.TagMapValList[] のインデックス。タグの名前とページ番号でソートされている
    # s_indexのインデックスのタグに、startIndexからendIndexの情報を添える。startIndexからendIndexの間にあるs_indexは除外する。
    # ページ番号は、プログラムの中のデータでは0から始まるが、結果表示では1から始まるようにする。
    def __coninfostr(self,s_index,startIndex,endIndex):
        i=startIndex
        str=""
        firstItem=True
        while i<=endIndex:
            if s_index!=i:
                if firstItem==False:
                    str+=" "
                else:
                    firstItem=False
                str+="{0:d}:{1:s}{2:d}".format(self.TagMapValList[i].page+1,chr(0x41+int(self.TagMapValList[i].TagValue.x/200)),int(self.TagMapValList[i].TagValue.y/200)+1)
                #str+="{0:d}:({1:d},{2:d})".format(self.TagMapValList[i].page+1,self.TagMapValList[i].TagValue.x,self.TagMapValList[i].TagValue.y)
            i+=1
        return str

    def MakeConInfo(self):
        l = len(self.TagMapValList)
        beginIndex=0
        while beginIndex<l:
            text=self.TagMapValList[beginIndex].TagValue.text
            nextIndex=beginIndex+1
            while nextIndex < l:
                if self.TagMapValList[nextIndex].TagValue.text == text:
                    nextIndex+=1
                    continue
                else:
                    break;
            if (nextIndex-beginIndex)>1:    #接続先のないタグには接続情報を付けないようにする
                index=beginIndex
                while index<nextIndex:
                    text = self.__coninfostr(s_index = index,startIndex=beginIndex,endIndex=nextIndex-1);
                    page = self.TagMapValList[index].page
                    xpos = self.TagMapValList[index].TagValue.x
                    ypos = self.TagMapValList[index].TagValue.y
                    dir  = 0 if  self.TagMapValList[index].TagValue.attribute==1 else 3
                    if dir==0:
                        ypos+=10
                    else:
                        xpos+=10
                    if len(text)>0:              
                        self.ce3fileList[page].AppendComment(layer=self.InfoLayer,xpos=xpos,ypos=ypos,text=text,dir=dir,fontsize=9)
                    #print(text)
                    index+=1
                #print("")
            beginIndex=nextIndex



# ファイルのバックアップを作る。
# パス名の末尾に backupInfoName+番号 をつけたファイルにバックアップを作成する
def BackupFile(path,backupInfoName="_BAK_",maxBackupNumber=3):
    i=1
    while i<maxBackupNumber:
        pathBackup=path+backupInfoName+str(i)
        if not(os.path.isfile(pathBackup)):
            break
        i+=1
    #iが最古のバックアップ先
    while i>0:
        pathBackup_d=path+backupInfoName+str(i)
        if i==1:
            pathBackup_s = path
        else:
            pathBackup_s=path+backupInfoName+str(i-1)
        shutil.copy2(pathBackup_s,pathBackup_d)
        i-=1


def BackupFiles(pathList):
    for path in pathList:
        BackupFile(path=path)



def MakeCE3TagConnectionInfo(pathList,infoLayer=5,bCleanupMapLayer=True,bUpdatePageNumber=True):
    ce3tagConInfo = CE3TagConInfo()
    ce3tagConInfo.Read_Files(pathList=pathList,infoLayer=infoLayer,bCleanupMapLayer=bCleanupMapLayer)
    ce3tagConInfo.dumpTagMapValList()
    ce3tagConInfo.MakeConInfo()
    if bUpdatePageNumber==True:
        ce3tagConInfo.Update_PageNumber()
    BackupFiles(pathList)
    ce3tagConInfo.Save_files()


if __name__ == '__main__':
    argv = sys.argv     # コマンドライン引数を得る
    argc = len(argv)    # コマンドライン引数の数

    filename = "filelist.txt"
    infoLayer=5
    bCleanupMapLayer=True
    bUpdatePageNumber=True
    
    print("CE3TagConInfo Version 0.01.00")

    i=1
    while i<argc :
        arg=argv[i];
        if arg[0]=="-":
            words = arg.split(":",1)
            if len(words)==2:
                try:
                    n=int(words[1])
                except:
                    n=0
                if words[0]=="-c":
                    bCleanupMapLayer = True if n!=0 else False
                elif words[0]=="-l":
                    infoLayer = n
                elif words[0]=="-p":
                    bUpdatePageNumber = True if n!=0 else False
        else:
            filename = argv[i]
        i+=1


    if infoLayer<1 or infoLayer>7:
        sys.exit()

  
    fnlist=[]

    f = open(filename, 'r',encoding='UTF-8')

    fullpath = os.path.abspath(filename)
    dirname = os.path.dirname(fullpath) 

    while True:
        line = f.readline()
        if line == '':
            break
        fname = line.strip();
        path = os.path.join(dirname,fname)
        fnlist.append(path)
        print (path)
    f.close()

    print("Info layer:"+str(infoLayer))
    print("Creanup info layer:"+("Do" if bCleanupMapLayer else "Not"))
    print("Update Page number:"+("Do" if bUpdatePageNumber else "Not"))


    MakeCE3TagConnectionInfo(pathList=fnlist,infoLayer=infoLayer,bCleanupMapLayer=bCleanupMapLayer,bUpdatePageNumber=bUpdatePageNumber)

