#もっともシンプルなCE3ファイルの読み書き。
#CSV要素ごとに

import sys
import os

class CE3DataElement:
    def __init__(self):
        self.word=''
        self.name=''    #wordを変数名と値にわけたあとの変数名
        self.val=''     #値
        self.depth=0    #+xxxx から -xxxxで表現される階層
        self.attribute=self.ATTRB_NORMAL

    ATTRB_NORMAL=0
    ATTRB_EOL=1

    def setword(self,s):
        self.word = s
        words = s.split(":",1)
        self.name=words[0]
        if len(words)==2:
            self.val = words[1]


def CE3string(str):
    retv=""
    for c in str:
        cn=ord(c)
        if cn<=0x20 or cn==0x25 or cn==0x2C:
            retv+="%"+format(cn,"02x")
        else:
            retv+=c
    return retv



class CE3Data:
    def __init__(self):
        self.filepath=''
        self.filename=''   #ディレクトリ、拡張子を除いたファイル名
        self.elementList=[]
        self.__dataDepth=0
        self.__endwordList=[]
      

    #図面構成要素の開始インデックスを取得する
    def GetSchematicObjBeginIndex(self,index):
        if index<0:
            return -1
        while index<len(self.elementList):
            elem = self.elementList[index]
            if elem.depth==2 and elem.word[0]=="+":
                return index
            index=index+1
        return -1
    
    #indexから始まる図面構成要素の終点インデックスを取得する
    def GetSchematicObjEndIndex(self,index):
        if index<0:
            return -1;
        index+=1    #終点検索は、開始点の次から
        while index<len(self.elementList):
            elem = self.elementList[index]
            if elem.depth==2 and elem.word[0]=="-":
                return index
            index=index+1
        return -1

    #indexBegin,indexEndの範囲の図面構成要素の指定変数のインデックスを取得する
    def GetSchematicObjVarIndex(self,indexBegin,indexEnd,varName):
        if indexBegin<0:
            return -1
        index=indexBegin
        while index<indexEnd:
            elem = self.elementList[index]
            if elem.depth==2 and elem.name==varName:
                return index
            index=index+1
        return -1
    
    #指定レイヤーを削除する
    def DeleteLayer(self,layer):
        index=0
        while True:
            index=self.GetSchematicObjBeginIndex(index)
            endindex=self.GetSchematicObjEndIndex(index)
            if index<0 or endindex<0:   #図面オブジェクトの範囲を正しく取得できなかったら終わる。
                break
            layerIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="L")   #図面オブジェクトの中からL:xを取り出す
            if layerIndex>0:    #L:xのデータ要素が見つかったら
                objLayer = int(self.elementList[layerIndex].val)    #L:xのxを数値にして
                if objLayer==layer:                                 #引数指定レイヤーと一致していたら
                    self.elementList[index:endindex+1]=[]           #その範囲を削除する。この場合 index は次の検索開始点になる。
                    continue
            index=endindex+1


           
    #1行分のデータを CE3DataElement にわけてelementListに追加する
    #private変数の__dataDepthと__endwordListを使う。あらかじめ適切に設定すること。
    #
    def InsertCE3Line(self,strLine,pos=1000000):
        words = strLine.split(',') 
        count = len(words)
        for index in range(count):
            word=words[index].strip()
            element = CE3DataElement()
            element.setword(word)
            if word[0]=="+":
                self.__dataDepth+=1
                element.depth = self.__dataDepth
                endword = "-"+word[1:]
                self.__endwordList.append(endword)
            elif self.__dataDepth>0 and word==self.__endwordList[-1]:
                element.depth = self.__dataDepth
                self.__endwordList.pop()
                self.__dataDepth -= 1
            else:
                element.depth = self.__dataDepth
            if index==(count-1):
                element.attribute = CE3DataElement.ATTRB_EOL
            self.elementList.insert(pos,element)


    # ページ番号の設定
    # CE3データの構造が想定外のとき1を返す
    def SetPageNumber(self,page,pages):
        index=self.GetSchematicObjBeginIndex(0)
        endindex=self.GetSchematicObjEndIndex(index) 
        if self.elementList[index].word!="+SHEETINFO":
            return 1
        
        varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="PAGE")   #図面オブジェクトの中からL:xを取り出す
        if varIndex<0:
            return 1
        self.elementList[varIndex].setword(s="PAGE:"+str(page))

        varIndex=self.GetSchematicObjVarIndex(indexBegin = index, indexEnd = endindex, varName="PAGES")   #図面オブジェクトの中からL:xを取り出す
        if varIndex<0:
            return 1
        self.elementList[varIndex].setword(s="PAGES:"+str(pages))

        return 0


    #+BSCH3_DATA_V.1.0 ~ -BSCH3_DATA_V.1.0 でくくられた self.elementList の末尾にコメントを追加する
    def AppendComment(self,layer,xpos,ypos,text,dir,fontsize,fontname="Verdana"):
        ce3text=CE3string(text)
        ce3fontname=CE3string(fontname)
        if layer < 0:
            layer = 0
        elif layer > 7:
            layer = 7
        if xpos < 0:
            xpos=0
        if ypos < 0:
            ypos=0
        if dir < 0:
            dir = 0
        elif dir > 3:
            dir = 3
        if fontsize<0:
            fontsize=0
        str = "+COMMENT,L:{0:d},X:{1:d},Y:{2:d},DIR:{3:d},W:-1,S:{4:s},FN:{5:s},TAG:0,FS:{6:d},FF:,-COMMENT".format(layer,xpos,ypos,dir,ce3text,ce3fontname,fontsize)
        self.__dataDepth=1     #+xxxxと-xxxxの階層
        self.__endwordList=[]  #階層の終端のワード -wire など
        self.InsertCE3Line(str,pos=-1)


        





    def ReadFile(self,filepath):
        f = open(filepath, 'r', encoding='UTF-8')
        self.filepath = filepath
        self.filename = os.path.splitext(os.path.basename(filepath))[0]

        self.__dataDepth=0     #+xxxxと-xxxxの階層
        self.__endwordList=[]  #階層の終端のワード -wire など

        self.elementList=[]
        while True:
            data = f.readline()
            if data == '':
                break

            self.InsertCE3Line(strLine=data)
        f.close()    

    def WriteFile(self,filepath=""):
        if len(filepath)==0:
            filepath=self.filepath
        f = open(filepath, 'w', encoding='UTF-8')
        for elem in self.elementList:
            f.write(elem.word)
            if elem.attribute== CE3DataElement.ATTRB_EOL:
                f.write("\r")
            else:
                f.write(",")
        f.close


# if __name__ == '__main__':
#     # テスト用

#     argv = sys.argv     # コマンドライン引数を得る
#     argc = len(argv)    # コマンドライン引数の数
#     if argc<2 :
#         srcfilepath = 'test.ce3'
#     else:
#         srcfilepath = argv[1]

#     dstfilepath = os.path.splitext(srcfilepath)[0]+"_copy.ce3"
#     ce3data = CE3Data()
#     ce3data.ReadFile(filepath=srcfilepath)
#     ce3data.DeleteLayer(5)
#     ce3data.AppendComment(4,250,120,"日本語コメントのテスト",3,12)
#     ce3data.WriteFile(filepath=dstfilepath)


